typedef unsigned char	u_char;
typedef unsigned short	u_short;
typedef unsigned int	u_int;
typedef unsigned long	u_long;

/*
 * Ethernet address - 6 octets
 */
struct ether_addr {
	u_char	ether_addr_octet[6];
};

/*
 * Structure of a 10Mb/s Ethernet header.
 */
struct	ether_header {
	struct	ether_addr ether_dhost;
	struct	ether_addr ether_shost;
	u_short	ether_type;
};

#define	ETHERPUP_IPTYPE		0x0800	/* IP protocol */
#define ETHERPUP_ARPTYPE	0x0806	/* Addr. resolution protocol */
#define ETHERPUP_REVARPTYPE	0x8035	/* Reverse ARP */
#define	IPPROTO_TCP		6	/* tcp */
#define	IPPROTO_UDP		17	/* user datagram protocol */
#define	IPVERSION		4
#define	MAXTTL			255	/* maximum time to live (seconds) */
#define	LOCALPORT		2000	/* used as local client port */

/*
 * Internet address (old style... should be updated)
 */
struct in_addr {
	u_long s_addr;
};

/*
 * Address to send replies for UDP packets
 */
struct hostaddr {
	struct	ether_addr ha_eaddr;
	u_short	ha_port;
	struct	in_addr ha_iaddr;
};

/*
 * Address resolution protocol (ARP) structure
 */
static struct ether_arp{
	struct ether_header arp_hdr;
	u_short	arp_hrd;
#define ARPHRD_ETHER	1
	u_short	arp_pro;
	u_char	arp_hln;
	u_char	arp_pln;
	u_short	arp_op;
#define ARPOP_REQUEST	1
#define ARPOP_REPLY	2
#define	REVARP_REQUEST	3
#define	REVARP_REPLY	4
	struct ether_addr arp_sha;	/* sender ether addr */
	struct in_addr arp_spa;		/* sender internet addr */
	struct ether_addr arp_tha;	/* target ether addr */
	struct in_addr arp_tpa;		/* target internet addr */
};

/*
 * Macros for number representation conversion.
 */
#define	ntohl(x)	(x)
#define	ntohs(x)	(x)
#define	htonl(x)	(x)
#define	htons(x)	(x)

/*
 * Structure of an internet header, naked of options.
 *
 * We declare ip_len and ip_off to be short, rather than u_short
 * pragmatically since otherwise unsigned comparisons can result
 * against negative integers quite easily, and fail in subtle ways.
 */
struct ip {
#ifdef vax
	u_char	ip_hl:4,		/* header length */
		ip_v:4;			/* version */
#endif
#if defined(mc68000) || defined(m32)
	u_char	ip_v:4,			/* version */
		ip_hl:4;		/* header length */
#endif
	u_char	ip_tos;			/* type of service */
	short	ip_len;			/* total length */
	u_short	ip_id;			/* identification */
	short	ip_off;			/* fragment offset field */
	u_char	ip_ttl;			/* time to live */
	u_char	ip_p;			/* protocol */
	u_short	ip_sum;			/* checksum */
	struct	in_addr ip_src,ip_dst;	/* source and dest address */
};

/*
 * Overlay for ip header used by other protocols (tcp, udp).
 */
struct ipovly {
	char	*ih_next, *ih_prev;	/* for protocol sequence q's */
	u_char	ih_x1;			/* (unused) */
	u_char	ih_pr;			/* protocol */
	short	ih_len;			/* protocol length */
	struct	in_addr ih_src;		/* source internet address */
	struct	in_addr ih_dst;		/* destination internet address */
};

/*
 * Udp protocol header.
 */
struct udphdr {
	u_short	uh_sport;		/* source port */
	u_short	uh_dport;		/* destination port */
	short	uh_ulen;		/* udp length */
	u_short	uh_sum;			/* udp checksum */
};

/*
 * Ethernet packet and UDP/IP hdr
 */
struct	udpiphdr {
	struct	ether_header ui_e;	/* ethernet header */
	struct 	ipovly ui_i;		/* overlaid ip structure */
	struct	udphdr ui_u;		/* udp header */
};
#define	ui_shost	ui_e.ether_shost
#define	ui_dhost	ui_e.ether_dhost
#define	ui_type		ui_e.ether_type
#define	ui_next		ui_i.ih_next
#define	ui_prev		ui_i.ih_prev
#define	ui_x1		ui_i.ih_x1
#define	ui_pr		ui_i.ih_pr
#define	ui_len		ui_i.ih_len
#define	ui_src		ui_i.ih_src
#define	ui_dst		ui_i.ih_dst
#define	ui_sport	ui_u.uh_sport
#define	ui_dport	ui_u.uh_dport
#define	ui_ulen		ui_u.uh_ulen
#define	ui_sum		ui_u.uh_sum

#define NETUDPIPHDRSIZE	sizeof(struct udpiphdr)
#define	UDPIPHDRSIZE	(sizeof(struct ipovly) + sizeof(struct udphdr))
#define	ETHERMAX	(1500 - UDPIPHDRSIZE)
#define	ETHERMIN	(46 - UDPIPHDRSIZE)
#define	ETHERMTU	1500
